//
//  MCTimePopups.h
//  TimePop
//
//  Created by Alykhan Jetha on Thu Mar 28 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

/*
	Expects hourPopup to have tags between and including 0 -> 23
	Expects minute popup to have tags 100, 115, 130, 145

	You can link the datefield, the date object is passed to it as an objectValue. The dateField's delegate should be this object.
	
	Includes binder support
	If the delegate of this object is a binder, then reallyTakeValueFrom: is called on the binder.



*/


#import <AppKit/AppKit.h>


@interface MCTimePopups : NSObject {

	id		hourPop;
	id		minutePop;
	
	id		priorTimePopups;
	id		postTimePopups;
	
	id		pushDateTarget; // if  this is set, then whenever the date change here, setDate is called on the  other time pop
	
	id		delegate; // not retained
	
	NSCalendarDate		*_passedInDate;
	
	int					_increamentDayOverPrior;
	int					_decreamentDayOverPost;
	
	id		dateField;
	BOOL	dateFieldIsChanging;

    id representedUIObject;
	
	BOOL	enabled;

}

// Returns the dateField's window
- (NSWindow *)window;


// use this if you want to change the date used when returns the latest time (replace the date set with setTime - Does not update popups
- (void)setDate:(NSCalendarDate *)value;

- (void)setTime:(NSCalendarDate *)value;
// Returns the new time -- values appended to the passed in date time if there is one
- (NSCalendarDate *)time;

- (void)setHourValue:(int)value;
- (int)hourValue;
- (void)setMinuteValue:(int)value;
- (int)minuteValue;

- (void)synchronizeWithPriorTimePopups:(MCTimePopups *)prior;
- (void)synchronizeWithPostTimePopups:(MCTimePopups *)post;


- (IBAction)takeHour:(id)sender;
- (IBAction)takeMinute:(id)sender;


- (void)setEnabled:(BOOL)flag;

- (id)representedUIObject;


// not retained
- (void)setDelegate:(id)aDeleg;
- (id)delegate;

@end


@interface NSObject (MCTimePopupsDelegate)

- (void)timePopupsDidUpdate:(MCTimePopups *)timePopups;

@end

